﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gml="http://www.opengis.net/gml"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl gml"
  xmlns:addindk="urn:addin.dk">
  <msxsl:script language="C#" implements-prefix="addindk">
      <![CDATA[
        public string Replace(string input)
        {
          return input.Replace('/','-');
        }
		public string GetKom(string input)
		{
		  return input.Substring(0,3);
		}
		public string GetEjd(string input)
		{
		  return input.Substring(3,input.Length-3);
		}
    ]]>
  </msxsl:script>
  <xsl:output method="html" indent="yes"/>
  <xsl:template match="/">
    <html>
      <head>
        <title></title>
        <style type="text/css">
          body {font-family: Arial, Helvetica, sans-serif;}
          table{border-collapse: collapse;
          font-size: 10pt;}
          td{padding: 2px;}
          .left {font-weight: bold;}
          .right{border-left: 2px solid #FFFFFF;}
          tr.even {
          background-color: #FCF6CF;
          }
          tr.odd {
          background-color: #FEFEF2;
          }
        </style>
      </head>
      <body>
        <table>
          <xsl:for-each select="./descendant::*">
            <tr>
              <xsl:if test="(position() mod 2 = 1)">
                <xsl:attribute name="class">even</xsl:attribute>
              </xsl:if>
              <xsl:if test="(position() mod 2 = 0)">
                <xsl:attribute name="class">odd</xsl:attribute>
              </xsl:if>
              <td class="left">
                <xsl:value-of select="local-name()"/>
              </td>
              <td class="right">
                <xsl:choose>
                  <xsl:when test="starts-with(text(),'http')">
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>
                    </a>
                  </xsl:when>
				  <xsl:when test="local-name()='langtFikspunktnummer'">
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;utm32Letrs89&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(UTM32)
                    </a>
					<br/>
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;s34jLL&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(S34J)
                    </a>
					<br/>
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;s34sLL&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(S34S)
                    </a>
					<br/>
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;dktm1L&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(DKTM1)
                    </a>
					<br/>
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;dktm2L&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(DKTM2)
                    </a>
					<br/>
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;dktm3L&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(DKTM3)
                    </a>
					<br/>
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>http://FriValde:FriValde@valdemar.kms.dk/cgi-valdemar/valdebsktxt?rgn&#61;DK&#38;crd&#61;dktm4L&#38;hgt&#61;h_dvr90&#38;stn&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>(DKTM4)
                    </a>
                  </xsl:when>
	              <xsl:when test="local-name()='kms_Journalnummer'">
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>https://services.gst.dk/reg/mao/sag.aspx?journalnr&#61;</xsl:text>
						<xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>
                    </a>
                  </xsl:when>
				  <xsl:when test="local-name()='esr_Ejendomsnummer'">
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:text>https://webois.lifa.dk/OIS/default.aspx?KomNr&#61;</xsl:text>
						<xsl:value-of select="addindk:GetKom(text())"/>
						<xsl:text>&#38;Ejdnr&#61;</xsl:text>
						<xsl:value-of select="addindk:GetEjd(text())"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>
                    </a>
                  </xsl:when>
				  
                  <xsl:otherwise>
                    <xsl:value-of select="text()"/>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>  
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>